﻿Namespace My

    Class MyApplication

        'Startup: 应用程序启动时在创建启动窗体之前引发。
        'Shutdown: 在所有应用程序窗体关闭后引发。如果应用程序是异常终止的，则不引发此事件。
        'UnhandledException: 在应用程序遇到未处理的异常时引发。
        'StartupNextInstance: 在启动单实例应用程序且应用程序已处于活动状态时引发。 
        'NetworkAvailabilityChanged: 在连接或断开网络连接时引发。

        ''' <summary>
        ''' 每当连接状态改变时，都更新主窗体的网络连接状态。
        ''' </summary>
        ''' <param name="sender"></param>
        ''' <param name="e"></param>
        ''' <remarks></remarks>
        Private Sub MyApplication_NetworkAvailabilityChanged(ByVal sender As Object, ByVal e As Microsoft.VisualBasic.Devices.NetworkAvailableEventArgs) Handles Me.NetworkAvailabilityChanged
            SetConnectionStatus(e.IsNetworkAvailable)
        End Sub

        ''' <summary>
        ''' 在此处包含任何窗体加载前应该执行的逻辑
        ''' </summary>
        ''' <param name="sender"></param>
        ''' <param name="e"></param>
        ''' <remarks></remarks>
        Private Sub MyApplication_Startup(ByVal sender As Object, ByVal e As Microsoft.VisualBasic.ApplicationServices.StartupEventArgs) Handles Me.Startup
            ' 应用程序启动时，在状态条上设置连接状态
            SetConnectionStatus(My.Computer.Network.IsAvailable)
        End Sub

        ''' <summary>
        ''' 更新状态条以表示当前的网络连接状态
        ''' </summary>
        ''' <param name="connected"></param>
        ''' <remarks></remarks>
        Public Sub SetConnectionStatus(ByVal connected As Boolean)
            With My.Forms.MainForm.ConnectedStatusLabel
                If (connected) Then
                    .Image = My.Resources.connected.ToBitmap
                    .Text = My.Resources.ConnectedText
                Else
                    .Image = My.Resources.disconnected.ToBitmap
                    .Text = My.Resources.DisconnectedText
                End If
            End With
        End Sub

    End Class
End Namespace

